VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsUserListings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'--------------------------------------------------------------------------------------------
'Description: Deals with all userlisting arrays and/or channellist manipulation excluding GUI
'--------------------------------------------------------------------------------------------

Private ChanHandler As New clsHandlerChannel

'Each bot gets there own UserListing
Private UserList()      As ULS
Private ClanList()      As UCLS
Private FriendsList()   As UFLS

'******************************
'UserListing Variables
'******************************

Private Type ULS
    'General Information:
    Username            As String
    Ping                As Long
    Flags               As Long
    Client              As String   '(Example: STAR)
    
    'ListView Attributes:
    '(Info: Everything should be nulled if a user is not in the channel anymore.)
    ID_COLOR            As Long
    ICON_PRODUCT        As Integer
    Stats               As String   'User's Stats
    
    'Extended information (Most likely serves for features)
    Idle                As Long     'Tracks the last time a user spoke
End Type

Private Type UCLS
    Username            As String
    ICON_RANK           As Integer
    Information         As String
    ForeColor           As Long
End Type

Private Type UFLS
    Username            As String
    ICON_CODE           As Integer
    ICON_ONLINE         As Integer
    Information         As String
End Type

Public Enum LISTINGTYPE
    CHANNEL_USER = 1
    CLAN_USER = 2
    FRIEND_USER = 3
End Enum


Public Sub addUserChannel(ByVal Username As String, ByVal Ping As Long, ByVal Flags As Long, ByVal Client As String, ByVal ID_COLOR As Long, ByVal ICON_PRODUCT As Integer, ByVal Stats As String)
    Dim Index As Integer
    Index = getIndex(CHANNEL_USER, Username)
    If (Index = -1) Then 'Not in list
        With UserList(UBound(UserList))
            .Username = Username
            .Ping = Ping
            .Flags = Flags
            .Client = Client
            .ID_COLOR = ID_COLOR
            .ICON_PRODUCT = ICON_PRODUCT
            .Stats = Stats
        End With
        ReDim Preserve UserList(UBound(UserList) + 1)
    Else
        With UserList(Index)
            .Username = Username
            .Ping = Ping
            .Flags = Flags
            .Client = Client
            .ID_COLOR = ID_COLOR
            .ICON_PRODUCT = ICON_PRODUCT
            .Stats = Stats
        End With
    End If
End Sub

Public Sub addUserClan(ByVal Username As String, ByVal ICON_RANK As Integer, ByVal ForeColor As Long, ByVal Info As String)
    Dim Index As Integer
    Index = getIndex(CLAN_USER, Username)
    If (Index) = -1 Then 'Not in list
        With ClanList(UBound(ClanList))
            .Username = Username
            .ICON_RANK = ICON_RANK
            .ForeColor = ForeColor
            .Information = Info
        End With
        ReDim Preserve ClanList(UBound(ClanList) + 1)
    Else
        With ClanList(Index)
            .Username = Username
            .ICON_RANK = ICON_RANK
            .ForeColor = ForeColor
            .Information = Info
        End With
    End If
End Sub

Public Sub addUserFriend(ByVal Username As String, ByVal ICON_CODE As Integer, ByVal ICON_ONLINE As Integer, ByVal Info As String)
    Dim Index As Integer
    Index = getIndex(FRIEND_USER, Username)
    If (Index) = -1 Then 'Not in list
        With FriendsList(UBound(FriendsList))
            .Username = Username
            .ICON_CODE = ICON_CODE
            .ICON_ONLINE = ICON_ONLINE
            .Information = Info
        End With
        ReDim Preserve FriendsList(UBound(FriendsList) + 1)
    Else
        With FriendsList(Index)
            .Username = Username
            .ICON_CODE = ICON_CODE
            .ICON_ONLINE = ICON_ONLINE
            .Information = Info
        End With
    End If
End Sub

Public Sub remUser(ByVal Listing As LISTINGTYPE, ByVal Username As String) 'Universal
    Dim Index As Integer, i As Integer
    Index = getIndex(Listing, Username)
    If (Index = -1) Then Exit Sub 'Not in the list
    
    Select Case Listing
        Case LISTINGTYPE.CHANNEL_USER
            If (Index < UBound(UserList)) Then
                For i = Index To UBound(UserList) - 1
                    UserList(i) = UserList(i + 1)
                Next i
                ReDim Preserve UserList(UBound(UserList) - 1)
            End If
        Case LISTINGTYPE.CLAN_USER
            If (Index < UBound(ClanList)) Then
                For i = Index To UBound(ClanList) - 1
                    ClanList(i) = ClanList(i + 1)
                Next i
                ReDim Preserve ClanList(UBound(ClanList) - 1)
            End If
        Case LISTINGTYPE.FRIEND_USER
            If (Index < UBound(FriendsList)) Then
                For i = Index To UBound(FriendsList) - 1
                    FriendsList(i) = FriendsList(i + 1)
                Next i
                ReDim Preserve FriendsList(UBound(FriendsList) - 1)
            End If
    End Select
End Sub

Public Function getIndex(ByVal Listing As LISTINGTYPE, ByVal Username As String) As Integer 'Universal
    Dim i As Integer
    Select Case Listing
        Case LISTINGTYPE.CHANNEL_USER
            For i = 0 To UBound(UserList) - 1
                If (StrComp(UserList(i).Username, Username, vbTextCompare) = 0) Then
                    getIndex = i
                    Exit Function
                End If
            Next i
        Case LISTINGTYPE.CLAN_USER
            For i = 0 To UBound(ClanList) - 1
                If (StrComp(ClanList(i).Username, Username, vbTextCompare) = 0) Then
                    getIndex = i
                    Exit Function
                End If
            Next i
        Case LISTINGTYPE.FRIEND_USER
            For i = 0 To UBound(FriendsList) - 1
                If (StrComp(FriendsList(i).Username, Username, vbTextCompare) = 0) Then
                    getIndex = i
                    Exit Function
                End If
            Next i
    End Select
    getIndex = -1
End Function

Public Sub setChannelListItems(Listing As LISTINGTYPE, ByVal ListView As ListView)
    Dim i           As Integer
    Dim Placement   As Integer
    Dim ChanHandler As New clsHandlerChannel
    
    ListView.ListItems.Clear
    
    Select Case Listing
        Case LISTINGTYPE.CHANNEL_USER
            For i = 0 To UBound(UserList) - 1
                
                If ((UserList(i).Flags And BNFLAGS_BLIZZ) = BNFLAGS_BLIZZ) Then
                    Placement = 1
                ElseIf ((UserList(i).Flags And BNFLAGS_OP) = BNFLAGS_OP) Then
                    Placement = 1
                ElseIf ((UserList(i).Flags And BNFLAGS_SQUELCH) = BNFLAGS_SQUELCH) Then
                    Placement = frmMain.lvUsers.ListItems.Count + 1
                Else
                    Placement = frmMain.lvUsers.ListItems.Count + 1
                End If
                
                Call ChanHandler.addItemToListView(ListView, UserList(i).Username, _
                    UserList(i).ICON_PRODUCT, ChanHandler.getLagIcon(UserList(i).Ping, UserList(i).Flags), _
                    UserList(i).ID_COLOR, "Ping at logon: " & UserList(i).Ping & "ms" & vbNewLine & "Flags: " & UserList(i).Flags & vbNewLine & vbNewLine & ChanHandler.MakeLongClientName(UserList(i).Client) & vbNewLine & "Stats: " & UserList(i).Stats, _
                    Placement)
            Next i
            
        Case LISTINGTYPE.CLAN_USER
            For i = 0 To UBound(ClanList) - 1
                If (ClanList(i).ICON_RANK = ICON_LEADER Or (ClanList(i).ICON_RANK = ICON_OFFICER And frmMain.lvClan.ListItems.Count = 0)) Then
                    Call ChanHandler.addItemToListView(frmMain.lvClan, ClanList(i).Username, ClanList(i).ICON_RANK, 0, ClanList(i).ForeColor, ClanList(i).Information, 1)
                ElseIf (ClanList(i).ICON_RANK = ICON_OFFICER) Then
                    Call ChanHandler.addItemToListView(frmMain.lvClan, ClanList(i).Username, ClanList(i).ICON_RANK, 0, ClanList(i).ForeColor, ClanList(i).Information, 2)
                Else
                    Call ChanHandler.addItemToListView(frmMain.lvClan, ClanList(i).Username, ClanList(i).ICON_RANK, 0, ClanList(i).ForeColor, ClanList(i).Information, frmMain.lvClan.ListItems.Count + 1)
                End If
            Next i
            
        Case LISTINGTYPE.FRIEND_USER
            For i = 0 To UBound(FriendsList) - 1
                Select Case FriendsList(i).ICON_ONLINE
                    Case ICON_GORB
                        Call ChanHandler.addItemToListView(ListView, FriendsList(i).Username, FriendsList(i).ICON_CODE, _
                            FriendsList(i).ICON_ONLINE, COLORS.ID_COLOR_SUCCEED, FriendsList(i).Information, ListView.ListItems.Count + 1)
                    Case ICON_RORB
                        Call ChanHandler.addItemToListView(ListView, FriendsList(i).Username, FriendsList(i).ICON_CODE, _
                            FriendsList(i).ICON_ONLINE, COLORS.ID_COLOR_FAILED, FriendsList(i).Information, ListView.ListItems.Count + 1)
                End Select
            Next i
    End Select
End Sub

Public Function getUserPing(ByVal Username As String) As Long
    Dim Index As Integer
    Index = getIndex(CHANNEL_USER, Username)
    If (Index > -1) Then
        getUserPing = UserList(Index).Ping
    Else
        getUserPing = 0
    End If
End Function

Public Function getUserFlags(ByVal Username As String) As Long
    Dim Index As Integer
    Index = getIndex(CHANNEL_USER, Username)
    If (Index > -1) Then
        getUserFlags = UserList(Index).Flags
    Else
        getUserFlags = 0
    End If
End Function

Public Function getUserStats(ByVal Username As String) As String
    Dim Index As Integer
    Index = getIndex(CHANNEL_USER, Username)
    If (Index > -1) Then
        getUserStats = UserList(Index).Stats
    Else
        getUserStats = vbNullString
    End If
End Function

Public Function getUserProduct(ByVal Username As String) As String
    Dim Index As Integer
    Index = getIndex(CHANNEL_USER, Username)
    If (Index > -1) Then
        getUserProduct = UserList(Index).Client
    Else
        getUserProduct = vbNullString
    End If
End Function

Public Function getUserIdleTime(ByVal Index As Integer)
    If (Index > -1 And Index < UBound(UserList)) Then
        getUserIdleTime = UserList(Index).Idle
    End If
End Function

Public Function updateUserIdleTime(ByVal Username As String) As Boolean
    Dim UserIndex   As Integer
    UserIndex = getIndex(CHANNEL_USER, Username)
    If (UserIndex > -1 And UserIndex < UBound(UserList)) Then
        UserList(UserIndex).Idle = GetTickCount()
        updateUserIdleTime = True
    End If
End Function

Public Function handleFriendsList(ByVal Index As Integer, ByVal Username As String, ByVal Status As Long, ByVal lngLocation As Long, ByVal ProductID As String, ByVal Channel As String)
    Dim Info    As String
    Dim Mutual  As Boolean
    Dim ICON_CODE As Long, ICON_ONLINE As Long, ID_COLOR As Long
    
    ICON_CODE = ChanHandler.getProductIcon(ProductID, 0) 'No flags
    If (ICON_CODE = ICON_QUESTION) Then ICON_CODE = ICON_SQUELCH 'Squelch icon instead.
        
    If ((Status And FRL_MUTUAL) = FRL_MUTUAL) Then
        Mutual = True
    End If
    
    If (Mutual = True) Then
        Info = "Mutual friend using " & ChanHandler.MakeLongClientName(ProductID) & vbNewLine
    'ElseIf (Mutual = False And (lngLocation And FRL_OFFLINE) <> FRL_OFFLINE) Then
    Else
        Info = "Using " & ChanHandler.MakeLongClientName(ProductID) & vbNewLine
    End If
    
    'Set initially
    ICON_ONLINE = ICON_GORB             'Online icon
    ID_COLOR = COLORS.ID_COLOR_SUCCEED  'Online color
    
    'Possible values for Location:
    '0x00: Offline
    '0x01: Not in chat
    '0x02: In chat
    '0x03: In a public game
    '0x05: In a private game
    
    'Get exact location
    If ((lngLocation And FRL_INPRIVGAME) = FRL_INPRIVGAME) Then
        If (Mutual) Then
            Info = Info & "Currently: In private game " & Channel & "."
        Else
            Info = Info & "Currently: In a private game."
        End If
    ElseIf ((lngLocation And FRL_INPUBGAME) = FRL_INPUBGAME) Then
        If (Mutual) Then
            Info = Info & "Currently: In public game " & Channel & "."
        Else
            Info = Info & "Currently: In a public game."
        End If
    ElseIf ((lngLocation And FRL_INCHAT) = FRL_INCHAT) Then
        If (Mutual) Then
            Info = Info & "Currently: Chatting in " & Channel & "."
        Else
            Info = Info & "Currently: Chatting in a channel."
        End If
    ElseIf ((lngLocation And FRL_NOTINCHAT) = FRL_NOTINCHAT) Then
        Info = Info & "Currently: Not chatting."
    ElseIf ((lngLocation And FRL_OFFLINE) = FRL_OFFLINE) Then
        Info = Info & "Currently: Offline."
        ICON_ONLINE = ICON_RORB                          'Offline icon
        ID_COLOR = COLORS.ID_COLOR_FAILED                'Offline color
    Else
        Info = Info & "Currently: Offline."
        ICON_ONLINE = ICON_RORB
        ID_COLOR = COLORS.ID_COLOR_FAILED
    End If
    
    Call addUserFriend(Username, ICON_CODE, ICON_ONLINE, Info)
    
    'Add to channellist
    If (BotIndex = Index) Then
        Call ChanHandler.addItemToListView(frmMain.lvFriends, Username, ICON_CODE, 0, ID_COLOR, Info, frmMain.lvFriends.ListItems.Count + 1)
    End If
    
    Call addUserFriend(Username, ICON_CODE, ICON_ONLINE, Info) 'Add to array listing
End Function

Public Sub handleClanList(ByVal Index As Integer, ByVal Username As String, ByVal Rank As Long, ByVal OnlineStatus As Long)
    'Possible values for Status:
    '
    '0x00: Offline
    '0x01: Online
    '
    'Possible values for Rank:
    '
    '0x00: Initiate that has been in the clan for less than one week
    '0x01: Initiate that has been in the clan for over one week
    '0x02: Member
    '0x03: Officer
    '0x04: Leader
    
    Dim ForeColor       As Long
    Dim ICON_RANK       As Long
    Dim Info            As String
    
    If (OnlineStatus And CLN_ONLINE) = CLN_ONLINE Then
        ForeColor = COLORS.ID_COLOR_SUCCEED
        Info = "Status: Online" & vbNewLine
    Else
        ForeColor = COLORS.ID_COLOR_FAILED
        Info = "Status: Offline" & vbNewLine
    End If
        
    Select Case Rank
        Case CLN_INITIATE1W
            ICON_RANK = ICON_INITIATE0
            Info = Info & "Current rank: Initiate that has been in the clan for less than one week"
        Case CLN_INITIATE2W
            ICON_RANK = ICON_INITIATE1
            Info = Info & "Current rank: Initiate that has been in the clan for over one week"
        Case CLN_MEMBER
            ICON_RANK = ICON_MEMBER
            Info = Info & "Current rank: Member"
        Case CLN_OFFICER
            ICON_RANK = ICON_OFFICER
            Info = Info & "Current rank: Officer"
        Case CLN_LEADER
            ICON_RANK = ICON_LEADER
            Info = Info & "Current rank: Leader"
        Case Else
            ICON_RANK = ICON_INITIATE0
            Info = Info & "Current rank: Unknown -> " & Rank
    End Select
    
    If (BotIndex = Index) Then
        If (ICON_RANK = ICON_LEADER Or (ICON_RANK = ICON_OFFICER And frmMain.lvClan.ListItems.Count = 0)) Then
            Call ChanHandler.addItemToListView(frmMain.lvClan, Username, ICON_RANK, 0, ForeColor, Info, 1)
        ElseIf (ICON_RANK = ICON_OFFICER) Then
            Call ChanHandler.addItemToListView(frmMain.lvClan, Username, ICON_RANK, 0, ForeColor, Info, 2)
        Else
            Call ChanHandler.addItemToListView(frmMain.lvClan, Username, ICON_RANK, 0, ForeColor, Info, frmMain.lvClan.ListItems.Count + 1)
        End If
    End If
    
    Call addUserClan(Username, ICON_RANK, ForeColor, Info)
End Sub

Public Sub Reset(Listing As LISTINGTYPE)
    Select Case Listing
        Case CHANNEL_USER
            ReDim UserList(0)
        Case CLAN_USER
            ReDim ClanList(0)
        Case FRIEND_USER
            ReDim FriendsList(0)
    End Select
End Sub

Private Sub Class_Initialize()
    ReDim UserList(0)
    ReDim ClanList(0)
    ReDim FriendsList(0)
End Sub

Private Sub Class_Terminate()
    ReDim UserList(0)
    ReDim ClanList(0)
    ReDim FriendsList(0)
End Sub

